<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('業務 儀表板') }}<span class="px-2">{{$brand_category}}/{{$series_category}}/{{$product_categories}}/{{$system_category}}規格選擇</span>
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 gap-6 md:grid-cols-3 mt-[100px] md:px-2 px-2 snap-x snap-mandatory"> 
                <!--產品卡片-->
                @forelse ($products as $product)
                    <form action="{{ route('cart.add') }}" method="POST">
                    @csrf
                        <div class="max-w-sm rounded-lg overflow-hidden shadow-lg bg-white p-6 flex flex-col items-center text-center">
                            <!-- 產品圖片 -->
                            <img class="h-48 object-cover rounded-lg" src="{{ asset('images/products/'.$product->image) }}" alt="{{ $product->image }}">
                            <!-- 產品資訊 -->
                            <div class="py-4">
                                <h2 class="text-lg font-semibold">angled</h2>
                                <p class="mt-1">{{$product['product_name']}}</p>
                                <p class="mt-1">產品ID：{{$product['product_id']}}</p>
                                <p class="mt-1">規格：</p>
                                <div class="flex gap-4 items-center justify-center text-center">
                                    @if(!empty($product->diameter))
                                    <div>直徑：{{ $product->diameter }}</div>
                                    @endif
                                    @if(!empty($product->length))
                                    <div>長度：{{ $product->length }}</div>
                                    @endif
                                    @if(!empty($product->high))
                                    <div>高度：{{ $product->high }}</div>
                                    @endif
                                    @if(!empty($product->cuff))
                                    <div>cuff：{{ $product->cuff }}</div>
                                    @endif
                                    @if(!empty($product->angle))
                                    <div>angle：{{ $product->angle }}°</div>
                                    @endif
                                    @if(!empty($product->type))
                                    <div>type：{{ $product->type }}</div>
                                    @endif
                                    @if(!empty($product->post_h))
                                    <div>PostH：{{ $product->post_h }}</div>
                                    @endif
                                </div>
                            </div>
                            <!-- 隱藏欄位 -->
                            <input type="hidden" name="brand_category" value="{{ $product->brand_category }}">
                            <input type="hidden" name="brand_category_logo" value="{{ $product->brand_category_logo }}">
                            <input type="hidden" name="series_category" value="{{ $product->series_category }}">
                            <input type="hidden" name="product_categories" value="{{ $product->product_categories }}">
                            <input type="hidden" name="system_category" value="{{ $product->system_category }}">
                            <input type="hidden" name="product_id" value="{{ $product->product_id }}">
                            <input type="hidden" name="product_name" value="{{ $product->product_name }}">
                            <input type="hidden" name="diameter" value="{{ $product->diameter }}">
                            <input type="hidden" name="length" value="{{ $product->length }}">
                            <input type="hidden" name="high" value="{{ $product->high }}">
                            <input type="hidden" name="cuff" value="{{ $product->cuff }}">
                            <input type="hidden" name="angle" value="{{ $product->angle }}">
                            <input type="hidden" name="type" value="{{ $product->type }}">
                            <input type="hidden" name="post_h" value="{{ $product->post_h }}">
                            <input type="hidden" name="image" value="{{ $product->image }}">
                            <!-- 加入購物車按鈕 -->
                            <div class="mt-4">
                                <button type="submit" class="px-4 py-2 mx-5 bg-[#1b1b18] text-white rounded-lg hover:bg-[#FDFDFC] focus:outline-none focus:ring-2 focus:ring-blue-500">
                                    加入詢價
                                </button>
                            </div>
                        </div>
                    </form>         
                 @empty
                 <div class="bg-white overflow-hidden shadow-xl sm:rounded-lg">
                    <div class="max-w-sm mx-auto bg-white rounded-lg shadow-lg overflow-hidden flex items-center justify-center p-4 hover:shadow-xl transition-shadow duration-300">
                        <div>
                            <h3 class="text-lg font-semibold text-gray-900 m-16">無搜尋到任何產品</h3>
                        </div>
                    </div>
                </div>  
                @endforelse
                @if(session('message'))
                    <script>
                        alert("{{ session('message') }}");
                    </script>
                @endif
            </div> 
        </div>
    </div>
</x-app-layout>